<?php
// إعدادات قاعدة البيانات (يمكنك تعديلها إذا أردت قاعدة بيانات منفصلة للأدمن)
if (!defined('DB_HOST')) define('DB_HOST', 'localhost');
if (!defined('DB_USER')) define('DB_USER', 'root');
if (!defined('DB_PASS')) define('DB_PASS', '');
if (!defined('DB_NAME')) define('DB_NAME', 'sms_elsory');

// إعدادات API خاصة بالأدمن (إذا كان هناك API منفصل)
if (!defined('ADMIN_API_URL')) define('ADMIN_API_URL', 'http://localhost:5000/api/admin');

// بدء الجلسة
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// تفعيل الأخطاء
error_reporting(E_ALL);
ini_set('display_errors', 1);

// الاتصال بقاعدة البيانات
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
$conn->set_charset("utf8");

// دالة API خاصة بالأدمن
function callAdminAPI($endpoint, $method = 'GET', $data = null) {
    $curl = curl_init();
    $url = ADMIN_API_URL . '/' . $endpoint;
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => $method,
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
    ]);
    if ($data) {
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
    }
    $response = curl_exec($curl);
    curl_close($curl);
    return json_decode($response, true);
}

// حماية الأدمن
function requireAdminAuth() {
    if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
        header("Location: ../login.php");
        exit;
    }
}

if (!function_exists('getAdminDBConnection')) {
    function getAdminDBConnection() {
        global $conn;
        return $conn;
    }
}
